// MIDASSERVERIMPL.H : Declaration of the MidasServer

#ifndef __MIDASSERVERIMPL_H_
#define __MIDASSERVERIMPL_H_

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>

#include "MidasServer_TLB.h"
#include <BdeProv.hpp>
#include <Db.hpp>
#include <DBTables.hpp>
#include <Provider.hpp>
#include <atl/atlvcl.h>


// Forward ref. of IDataBroker implementor
//


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
class TMidasServer : public TDataModule
{
__published:  // IDE-managed Components
  TTable *TableCustomer;
  TDataSource *DataSource1;
  TTable *TableOrders;
  TDataSource *DataSource2;
  TProvider *ProviderCustomer;
private:      // User declarations
public:       // User declarations
  __fastcall TMidasServer(TComponent* Owner);

__published:
};


/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
extern PACKAGE TMidasServer *MidasServer;


/////////////////////////////////////////////////////////////////////////////
// TMidasServerImpl     Implements IMidasServer, default interface of MidasServer
// ThreadingModel : Apartment
// Dual Interface : TRUE
// Event Support  : FALSE
// Default ProgID : Project1.MidasServer
// Description    : Dr. Bob's MIDAS Data Server
/////////////////////////////////////////////////////////////////////////////
class ATL_NO_VTABLE TMidasServerImpl: REMOTEDATAMODULE_IMPL(TMidasServerImpl, MidasServer, TMidasServer, IMidasServer)
{
public:

BEGIN_COM_MAP(TMidasServerImpl)
  AUTOOBJECT_COM_INTERFACE_ENTRIES(IMidasServer)
END_COM_MAP()

  // Data used when registering Object 
  //
  DECLARE_THREADING_MODEL(otApartment);
  DECLARE_PROGID("MidasServer.MidasServer");
  DECLARE_DESCRIPTION("Dr. Bob's MIDAS Data Server");

  // Function invoked to (un)register object
  //
  static HRESULT WINAPI UpdateRegistry(BOOL bRegister)
  {
    TRemoteDataModuleRegistrar regObj(GetObjectCLSID(), GetProgID(), GetDescription());
    return regObj.UpdateRegistry(bRegister);
  }


// IMidasServer
protected: 
  STDMETHOD(get_ProviderCustomer(IProvider** Value));
};

#endif  // __MIDASSERVERIMPL_H_ 

